/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Developmentteam.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include <math.h>            // fabs( ... )
#include <stdlib.h>
#include "randlib.h"
#include "strutil.h"       // str2float( ... )

/*******************************************************************
* Function Name: Developmentteam
* Description: constructor
********************************************************************/
Developmentteam::Developmentteam( const string &name )
: Atomic( name )
, bugout(addInputPort( "bugout" ))
, devtimein(addInputPort( "devtimein" ))
, bugin(addOutputPort( "bugin" ))
, devtimeout(addOutputPort( "devtimeout" ))
, preparationTime( 0, 0, 0, 0 )
{

	string time( MainSimulator::Instance().getParameter( description(), "preparation" ) ) ;

	if( time != "" )
		preparationTime = time ;
	// read distribution parameters:

	dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
	MASSERT( dist ) ;
	for ( register int i = 0; i < dist->varCount(); i++ )
		{
		string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) ) ;
		dist->setVar( i, str2Value( parameter ) ) ;
		}

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Developmentteam::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	//this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	//this->sigma = Time::Zero; // force an internal transition in t=0;

 	// TODO: add init code here. (setting first state, etc)
 	
 	// set next transition
 	//holdIn( active, this->sigma  ) ;
 	bug = 0;
 	totimptime = 0;
 	randnum = 0;
 	this->passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Developmentteam::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	

	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 

 if ( this->state() == passive )
 {
 	int bo = 0;
	int impt = 0;

	if(msg.port() == devtimein){

		impt = msg.value();
	}
	if(msg.port() == bugout){
			bo = msg.value();
	}

		randnum = rand() % 100;
		if (randnum < 90){ //when there is a bug
			bug = 1;
			totimptime = impt+(impt/2);
			holdIn( active, preparationTime );
			//holdIn( active, Time( static_cast<float>( fabs( distribution().get() ) ) ) );

		}else{ //when there is no bug
			bug = 0;
			totimptime = impt;
			holdIn( active, preparationTime );
			//holdIn( active, Time( static_cast<float>( fabs( distribution().get() ) ) ) );
		}

 }
	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Developmentteam::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here

	totimptime = 0;
	bug = 0;
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );

	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Developmentteam::outputFunction( const InternalMessage &msg )
{
	//TODO: implement the output function here
	// remember you can use sendOutput(time, outputPort, value) function.
	if(bug == 1)
		sendOutput( msg.time(), bugin , bug ) ;
	if(totimptime != 0)
		sendOutput( msg.time(), devtimeout , totimptime  ) ;
	
	return *this;

}

Developmentteam::~Developmentteam()
{
	delete dist;
	//TODO: add destruction code here. Free distribution memory, etc. 
}
